# Read in n
n = int(input())

# Read quadrupled distribution and keep track of faces that must be present
faces = []
curr_quad = {} # Quadrupling distribution with current faces
min_f = 100000000 # Initialize minimal face to something too big

# process all values in order; automatically sorts output as well
for l in range(n):
    q, k = [int(i) for i in input().split()]
    if min_f > q // 4: # Set min face if not determined yet
        min_f = q // 4
    if q not in curr_quad or curr_quad[q] < k:
        # Minimum not fully covered must be min + min + min + x for a missing face x
        new = q - 3 * min_f
        # Now just recompute the additional combinations that emerge
        # loop over all triples of old faces (single new face)
        for i1 in range(len(faces)):
            for i2 in range(len(faces)):
                for i3 in range(len(faces)):
                    f1 = faces[i1]
                    f2 = faces[i2]
                    f3 = faces[i3]
                    # and combine with the new face
                    val = new + f1 + f2 + f3
                    # new face can be in 4 positions
                    if val not in curr_quad:
                        curr_quad[val] = 4
                    else:
                        curr_quad[val] += 4
        # double new face
        for i1 in range(len(faces)):
            for i2 in range(len(faces)):
                f1 = faces[i1]
                f2 = faces[i2]
                # combine with the new face
                val = 2 * new + f1 + f2
                # 6 possibilities for combinations of new face
                if val not in curr_quad:
                    curr_quad[val] = 6
                else:
                    curr_quad[val] += 6
        # triple new face
        for i1 in range(len(faces)):
            f1 = faces[i1]
            # combine with the new face
            val = 3 * new + f1
            # 4 possibilities for combinations of new face
            if val not in curr_quad:
                curr_quad[val] = 4
            else:
                curr_quad[val] += 4
        # quadruple new face
        val = 4 * new
        # single possibility for combinations of new face
        if val not in curr_quad:
            curr_quad[val] = 1
        else:
            curr_quad[val] += 1
        faces.append(new)

#output
print(len(faces))
for fc in faces:
    print(fc)
        
